#include "vars.h"
#include "input.h"
#include "ai.h"
#include "moves.h"



BALL* define_nearest_ball(PLAYER* p_player) {
   int i;
   int no_int_ball = TRUE;
   BALL* current_best_ball = ball[0];

   for (i = 0; i < nb_max_balls; ++i) {
      if (ball[i]->EXIST == FALSE)
         continue;
      
      if (ball[i]->speed.x>0 && p_player->pos == RIGHT) {
         if (current_best_ball->speed.x < 0) {
            current_best_ball = ball[i];
            no_int_ball = FALSE;
            continue;
         }
         else if (current_best_ball->position.x < ball[i]->position.x)
            current_best_ball = ball[i];
            no_int_ball = FALSE;            
         continue;
      }
      else if (ball[i]->speed.x < 0 && p_player->pos == LEFT) {
         if (current_best_ball->speed.x > 0) {
            current_best_ball = ball[i];
            no_int_ball = FALSE;            
            continue;
         }
         else if (current_best_ball->position.x > ball[i]->position.x)
            current_best_ball = ball[i];
            no_int_ball = FALSE;            
         continue;
      }
   }
   if (no_int_ball == FALSE)
      return current_best_ball;
   else
      return NULL;
}

double adjust_center_speed(PLAYER* p_player) {
   
   //pour l'instant, il ne cherche pas  aller plus ou moins vite
   return RACKET_ACC_Y; //*ABS(p_player->racket->position.y-SCREEN_H/2);
}

int define_pos_y_ball(BALL* p_b, PLAYER* p_player) {
   int pos_y;
   int r_pos_y = SCREEN_H/2;
   
   if (p_player->pos == LEFT)
      r_pos_y = p_b->position.y + (ABS(p_player->racket->position.x + p_player->racket->main_bitmap->w/2 - p_b->position.x + p_b->bitmap->w/2) / ABS(p_b->speed.x))*(p_b->speed.y);
   else if (p_player->pos == RIGHT)
      r_pos_y = p_b->position.y + (ABS(p_player->racket->position.x - p_player->racket->main_bitmap->w/2 - p_b->position.x - p_b->bitmap->w/2)/ABS(p_b->speed.x))*(p_b->speed.y);      

	if ((p_b->speed.y < 0 && r_pos_y < 0) || (p_b->speed.y > 0 && r_pos_y >= SCREEN_H)) {
		//cas pair
		if ((int)(ABS(r_pos_y) / SCREEN_H) % 2 == 1)
			pos_y = SCREEN_H - (ABS(r_pos_y) % SCREEN_H) ;
		else 
			pos_y = (ABS(r_pos_y) % SCREEN_H);
	}
	else 
		pos_y = r_pos_y;

   return pos_y;
}

int time_to_move(PLAYER* p_player, BALL *p_ball, int right_posy) {
   double ball_time = 0;
   double racket_time;
   
   if (p_player->pos == LEFT) 
      ball_time = ABS(p_ball->position.x - p_ball->bitmap->w/2 - p_player->racket->position.x - p_player->racket->main_bitmap->w/2)/(double)ABS(p_ball->speed.x);
   else if (p_player->pos == RIGHT) 
      ball_time = ABS(p_ball->position.x + p_ball->bitmap->w/2 - p_player->racket->position.x + p_player->racket->main_bitmap->w/2)/(double)ABS(p_ball->speed.x);   
      
   //15 % pour l'acclration
   racket_time = ABS(p_player->racket->position.y - right_posy)/(double)(RACKET_MAX_SPEED_Y-RACKET_MAX_SPEED_Y*0.04);
   
   if (ball_time <= racket_time)
      return TRUE;
   else 
      return FALSE;
      
}
   


//ICI, c'est notre AI qui compte!!
void gere_input_ai(PLAYER* p_player) {
   BALL* best_ball;
   //la position en y de l'interception probable entre la balle et la raquette du joueur
   int posy_ball_racket;
   

   p_player->racket->IS_MOVING = FALSE;
   best_ball = define_nearest_ball(p_player);
   
   //si on se fiche de la balle, on revient au centre.
   if (best_ball == NULL) {
      
      //on attend pour faire une crasse, on attend d'avoir une balle qui arrive
      p_player->racket->IS_WAITING_FOR_PITCH = FALSE;
      
      //si la rackette est trop basse
      if (p_player->racket->position.y > SCREEN_H/2+30) {
         p_player->racket->speed.y -= adjust_center_speed(p_player);
         p_player->racket->IS_MOVING = TRUE;
   
      }
      //si elle est trop haute
      else if (p_player->racket->position.y < SCREEN_H/2-30) {
         p_player->racket->speed.y += adjust_center_speed(p_player);
         p_player->racket->IS_MOVING = TRUE;
   
      }
   }         
   else {
      //sinon, on a une balle qui arrive vers nous ici
      //on rcupre l'ordonne de la collision entre la raquette et la balle ;)
      posy_ball_racket = define_pos_y_ball(best_ball, p_player);
      
      if (p_player->racket->IS_WAITING_FOR_PITCH == FALSE) {

         if (rand()%2 == 0) //en haut ou en bas ??
            p_player->racket->wait_position.y = posy_ball_racket + 175 - ABS(best_ball->speed.x*200) + rand()%100; //effets plus ou moins marqus
         else 
            p_player->racket->wait_position.y = posy_ball_racket - 175 + ABS(best_ball->speed.x*200) - rand()%100;
         p_player->racket->IS_WAITING_FOR_PITCH = TRUE;
         //Faut voir si on veut prendre une valeur en dehors de l'cran!
         
         if (p_player->racket->wait_position.y - p_player->racket->main_bitmap->h/2< 0)
            p_player->racket->wait_position.y = posy_ball_racket + 175 - ABS(best_ball->speed.x*200) + rand()%100;
         else if (p_player->racket->wait_position.y + p_player->racket->main_bitmap->h/2 >= SCREEN_H)
            p_player->racket->wait_position.y = posy_ball_racket - 175 + ABS(best_ball->speed.x*200) - rand()%100;         

        //ici, on vrifie si on a le temps de joindre le point dfinit par rapport au point de collision
         if (is_able_to_join_point(p_player, best_ball, p_player->racket->wait_position.y, posy_ball_racket) == FALSE) {
            p_player->racket->IS_WAITING_FOR_PITCH = FALSE;       //sinon, on se place tout de suite
            p_player->racket->wait_position.y = posy_ball_racket; //au point d'impact avec la balle
         }
      }
      
      //ici, on attend pour donner un effet  la balle
      if (p_player->racket->IS_WAITING_FOR_PITCH == TRUE) {
         //et si on faisait une petite crasse  notre adversaire?? Mhhh?
         if (time_to_move(p_player, best_ball, posy_ball_racket) == TRUE) {
            if (p_player->racket->wait_position.y < posy_ball_racket)
               p_player->racket->wait_position.y = posy_ball_racket + p_player->racket->main_bitmap->h/4;
            else 
               p_player->racket->wait_position.y = posy_ball_racket - p_player->racket->main_bitmap->h/4;
             
         }
      }

      if (p_player->racket->wait_position.y < p_player->racket->position.y-p_player->racket->main_bitmap->h/4) {
         p_player->racket->speed.y -= RACKET_ACC_Y;
         p_player->racket->IS_MOVING = TRUE;
      }      
      else if (p_player->racket->wait_position.y > p_player->racket->position.y  + p_player->racket->main_bitmap->h/4) {
         p_player->racket->speed.y += RACKET_ACC_Y;
         p_player->racket->IS_MOVING = TRUE;
      }
   }
    

   if (p_player->racket->speed.y < - RACKET_MAX_SPEED_Y)
      p_player->racket->speed.y = - RACKET_MAX_SPEED_Y;
     
   if (p_player->racket->speed.y > RACKET_MAX_SPEED_Y)
      p_player->racket->speed.y = RACKET_MAX_SPEED_Y;


   return;
}
   
int is_able_to_join_point(PLAYER* p_player, BALL* p_ball, int point_y, int impact_y) {
   int nb_needed_loops = 0;
   //La fonction ne tient pas compte de l'acclration dans les calculs
   
   //tout d'abord, on rcupre le nombre de boucles ncssaires pour joindre le point et revenir au point d'impact
   //2* pour aller et retour.
   //on le compare au nombre de boucles que prend la balle pour arriver sur la raquette

   nb_needed_loops = 2*ABS(p_player->racket->position.y - point_y)/RACKET_MAX_SPEED_Y;

   

   if (p_player->pos == LEFT) {
      //on minore de 15% pour la marge de l'acclration
      if (nb_needed_loops + nb_needed_loops*0.15 > ABS(p_ball->position.x - p_ball->bitmap->w/2 - p_player->racket->position.x - p_player->racket->main_bitmap->w/2)/ABS(p_ball->speed.x))
         return FALSE;
      else
         return TRUE;
   }
   else if (p_player->pos == RIGHT) {
      if (nb_needed_loops + nb_needed_loops*0.15 > ABS(p_ball->position.x + p_ball->bitmap->w/2 - p_player->racket->position.x + p_player->racket->main_bitmap->w/2)/ABS(p_ball->speed.x))
         return FALSE;
      else
         return TRUE;
   }      
   else
      return FALSE;
      
      
}
   